<?php

namespace common\models;

use Yii;

class Clones extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'clones';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['size'], 'default', 'value' => null],
            [['id', 'clonetype'], 'integer'],
            [['source', 'clone'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => 'Uploaded At',
            'bots' => 'Attached Bots',
            'admin_id' => 'Admin',
            'user_id' => 'Admin',
            
            'filename' => 'Real Filename',
            'storedfilename' => 'Stored Filename',
            'size' => 'Size',
            'filetype' => 'Filetype',
            'group' => 'Group',
            'destination' => 'Destination',
            'version' => 'Version',
            'current' => 'Current',
        ];
    }

    public function getSourceByClone($filename){
        
        //return static::findOne(['clone' => $filename])['source'];
        $s = static::find()->where(['clone' => $filename])->one();
        return (isset($s)) ? $s['source'] : null;
        
    }

}
